/*
 * Decompiled with CFR 0.152.
 */
package flash.localization;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleLocalizer
implements ILocalizer {
    public ILocalizedText getLocalizedText(Locale locale, String id) {
        int dot;
        String prefix = id;
        while ((dot = prefix.lastIndexOf(46)) != -1) {
            prefix = prefix.substring(0, dot);
            String suffix = id.substring(dot + 1);
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(prefix, locale);
                if (bundle == null || bundle.getObject(suffix) == null) continue;
                return new ResourceBundleText(bundle.getObject(suffix).toString());
            }
            catch (MissingResourceException e2) {
            }
        }
        return null;
    }

    private class ResourceBundleText
    implements ILocalizedText {
        private String text;

        public ResourceBundleText(String text) {
            this.text = text;
        }

        public String format(Map parameters) {
            return LocalizationManager.replaceInlineReferences(this.text, parameters);
        }
    }
}

