/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.g2d;

import flash.graphics.g2d.GraphicContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public abstract class AbstractGraphics2D
extends Graphics2D {
    protected GraphicContext graphicContext;

    protected AbstractGraphics2D(GraphicContext context) {
        this.graphicContext = context;
    }

    public void clip(Shape shape) {
        this.graphicContext.clip(shape);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    public void drawStringAsShape(String str, float x, float y) {
        GlyphVector gv = this.graphicContext.getFont().createGlyphVector(this.graphicContext.getFontRenderContext(), str);
        this.drawGlyphVector(gv, x, y);
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        Shape textOutline = gv.getOutline(x, y);
        this.fill(textOutline);
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver obs) {
        if (image != null && image instanceof BufferedImage) {
            Paint p = this.graphicContext.getPaint();
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, image.getWidth(obs), image.getHeight(obs));
            TexturePaint tp = new TexturePaint((BufferedImage)image, rect);
            this.graphicContext.setPaint(tp);
            this.fill(rect);
            this.graphicContext.setPaint(p);
        }
        return false;
    }

    public void drawImage(BufferedImage bi, BufferedImageOp op, int x, int y) {
        BufferedImage newBi = op.filter(bi, null);
        this.drawImage(newBi, new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)x, (double)y), null);
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform tx) {
        if (image != null) {
            BufferedImage bufferedImage = null;
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                ColorModel cm = image.getColorModel();
                Raster r = image.getData();
                WritableRaster wr = r.createCompatibleWritableRaster();
                bufferedImage = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
            }
            this.drawImage(bufferedImage, tx, null);
        }
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform tx) {
        AffineTransform tx3;
        AffineTransform tx1 = this.graphicContext.getTransform();
        AffineTransform tx2 = new AffineTransform(tx);
        tx2.concatenate(tx1);
        RenderContext renderContext = new RenderContext(tx2);
        try {
            tx3 = tx1.createInverse();
        }
        catch (NoninvertibleTransformException e2) {
            renderContext = new RenderContext(tx1);
            tx3 = new AffineTransform();
        }
        RenderedImage renderedimage = image.createRendering(renderContext);
        this.drawRenderedImage(renderedimage, tx3);
    }

    public Paint getPaint() {
        return this.graphicContext.getPaint();
    }

    public void setPaint(Paint paint) {
        this.graphicContext.setPaint(paint);
    }

    public Stroke getStroke() {
        return this.graphicContext.getStroke();
    }

    public void setStroke(Stroke stroke) {
        this.graphicContext.setStroke(stroke);
    }

    public void translate(int x, int y) {
        this.graphicContext.translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.graphicContext.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.graphicContext.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.graphicContext.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.graphicContext.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.graphicContext.shear(shx, shy);
    }

    public void transform(AffineTransform tx) {
        this.graphicContext.transform(tx);
    }

    public void setTransform(AffineTransform tx) {
        this.graphicContext.setTransform(tx);
    }

    public AffineTransform getTransform() {
        return this.graphicContext.getTransform();
    }

    public Color getBackground() {
        return this.graphicContext.getBackground();
    }

    public void setBackground(Color color) {
        this.graphicContext.setBackground(color);
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphicContext.getFontRenderContext();
    }

    public boolean hit(Rectangle rect, Shape shape, boolean onStroke) {
        if (onStroke) {
            shape = this.graphicContext.getStroke().createStrokedShape(shape);
        }
        shape = this.graphicContext.getTransform().createTransformedShape(shape);
        return shape.intersects(rect);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicContext.getDeviceConfiguration();
    }

    public void setComposite(Composite comp) {
        this.graphicContext.setComposite(comp);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphicContext.setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphicContext.getRenderingHint(hintKey);
    }

    public void setRenderingHints(Map hints) {
        this.graphicContext.setRenderingHints(hints);
    }

    public void addRenderingHints(Map hints) {
        this.graphicContext.addRenderingHints(hints);
    }

    public RenderingHints getRenderingHints() {
        return this.graphicContext.getRenderingHints();
    }

    public Composite getComposite() {
        return this.graphicContext.getComposite();
    }

    public Color getColor() {
        Paint p = this.graphicContext.getPaint();
        if (p instanceof Color) {
            return (Color)p;
        }
        return null;
    }

    public void setColor(Color c2) {
        this.graphicContext.setPaint(c2);
    }

    public void setPaintMode() {
        this.graphicContext.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color c1) {
        throw new RuntimeException("Not yet supported");
    }

    public Font getFont() {
        return this.graphicContext.getFont();
    }

    public void setFont(Font font) {
        this.graphicContext.setFont(font);
    }

    public FontMetrics getFontMetrics(Font f2) {
        return this.graphicContext.getFontMetrics(f2);
    }

    public Rectangle getClipBounds() {
        return this.graphicContext.getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.graphicContext.clipRect(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.graphicContext.setClip(x, y, width, height);
    }

    public Shape getClip() {
        return this.graphicContext.getClip();
    }

    public void setClip(Shape clip) {
        this.graphicContext.setClip(clip);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new RuntimeException("Not yet supported");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    public void fillRect(int x, int y, int width, int height) {
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, width, height);
        this.fill(r);
    }

    public void clearRect(int x, int y, int width, int height) {
        Paint temp = this.graphicContext.getPaint();
        this.graphicContext.setPaint(this.graphicContext.getBackground());
        this.fillRect(x, y, width, height);
        this.graphicContext.setPaint(temp);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.draw(rr);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.fill(rr);
    }

    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Double e2 = new Ellipse2D.Double(x, y, width, height);
        this.draw(e2);
    }

    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Double e2 = new Ellipse2D.Double(x, y, width, height);
        this.fill(e2);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double a2 = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(a2);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double a2 = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(a2);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = new Polygon(xPoints, yPoints, nPoints);
        this.draw(p);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = new Polygon(xPoints, yPoints, nPoints);
        this.draw(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon p = new Polygon(xPoints, yPoints, nPoints);
        this.fill(p);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        throw new RuntimeException("drawImage(Image, int, int, ImageObserver) not yet supported");
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        throw new RuntimeException("drawImage(Image, int, int, int, int, ImageObserver) not yet supported");
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        Paint paint = this.graphicContext.getPaint();
        this.graphicContext.setPaint(bgcolor);
        this.fillRect(x, y, width, height);
        this.graphicContext.setPaint(paint);
        this.drawImage(img, x, y, width, height, observer);
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = src.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        src = src.getSubimage(sx1, sy1, sx2 - sx1, sy2 - sy1);
        return this.drawImage(src, dx1, dy1, dx2 - dx1, dy2 - dy1, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint paint = this.graphicContext.getPaint();
        this.graphicContext.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.graphicContext.setPaint(paint);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public void dispose() {
        this.graphicContext = null;
    }
}

