/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.BatikFontManager;
import flash.fonts.CachedFontFace;
import flash.fonts.CachedFontManager;
import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontSet;
import flash.fonts.LocalFont;
import flash.swf.builder.types.PathIteratorWrapper;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.types.GlyphEntry;
import flash.util.Trace;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JREFontManager
extends CachedFontManager {
    private boolean readLocalFonts;
    private Map<String, LocalFont> localFonts;
    public static String LOCAL_FONTS_SNAPSHOT = "flex.fonts-snapshot";
    private String localFontsFile;
    private static ArrayList<String> systemFontNames = null;

    public void initialize(Map map) {
        super.initialize(map);
        if (map != null) {
            this.localFontsFile = (String)map.get(LOCAL_FONTS_SNAPSHOT);
        }
        if (this.localFontsFile == null) {
            this.localFontsFile = "localFonts.ser";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String createFontFromLocation(Object location, int requestedStyle, boolean useTwips) {
        String string;
        String family = null;
        InputStream is = null;
        try {
            if (location != null && location instanceof URL) {
                int guessedStyle;
                URL url = (URL)location;
                if (url.getProtocol().toLowerCase().indexOf("file") > -1) {
                    File f2 = new File(url.getFile());
                    is = new FileInputStream(f2);
                } else {
                    is = url.openStream();
                }
                Font font = Font.createFont(0, is);
                family = font.getFamily();
                String fontName = font.getFontName(Locale.ENGLISH);
                if (this.majorCompatibilityVersion < 4 && requestedStyle != (guessedStyle = CachedFontFace.guessStyleFromSubFamilyName(fontName))) {
                    String string2 = null;
                    return string2;
                }
                String locationStr = BatikFontManager.processLocation(location);
                org.apache.batik.svggen.font.Font batikFont = org.apache.batik.svggen.font.Font.create(locationStr);
                if (batikFont == null) {
                    throw new FontFormatException("Unable to create font.");
                }
                FSType type = FSType.getFSType(batikFont);
                if (!type.usableByFlex) {
                    throw new BatikFontManager.UnusableFontLicense(location + "", type.description);
                }
                String copyright = batikFont.getNameTable().getRecord((short)0);
                String trademark = batikFont.getNameTable().getRecord((short)7);
                Map<TextAttribute, ?> attributes = font.getAttributes();
                attributes.put(TextAttribute.FAMILY, family);
                attributes.put(TextAttribute.SIZE, DEFAULT_FONT_SIZE_OBJECT);
                attributes.put(TextAttribute.POSTURE, CachedFontFace.isItalic(requestedStyle) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                attributes.put(TextAttribute.WEIGHT, CachedFontFace.isBold(requestedStyle) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                font = font.deriveFont(attributes);
                FontSet fontSet = (FontSet)this.getFontCache().get(family);
                if (fontSet == null) {
                    fontSet = new FontSet(this.maxFacesPerFont);
                    this.getFontCache().put(family, fontSet);
                }
                fontSet.put(requestedStyle, new JREFontFace(font, requestedStyle, this.maxGlyphsPerFace, type, copyright, trademark, useTwips));
            }
        }
        catch (FileNotFoundException ex) {
            string = null;
            return string;
        }
        catch (FontFormatException ex) {
            string = null;
            return string;
        }
        catch (IOException ex2) {
            string = null;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable t) {}
        }
        return family;
    }

    public FontFace getEntryFromLocation(URL location, int style, boolean useTwips) {
        FontFace entry = null;
        Object fam = this.getFontFileCache().get(location);
        if (fam == null) {
            fam = this.createFontFromLocation(location, style, useTwips);
        }
        if (fam != null) {
            String family = fam.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get(family);
            if (fontSet != null) {
                entry = fontSet.get(style);
            }
        }
        return entry;
    }

    protected FontSet createSetForSystemFont(String family, int style, boolean useTwips) {
        FontSet fontSet = null;
        if (family != null) {
            if (systemFontNames == null) {
                JREFontManager.initializeSystemFonts();
            }
            if (systemFontNames != null && !systemFontNames.contains(family.trim().toLowerCase())) {
                if (Trace.font) {
                    Trace.trace("Font family '" + family + "' not known to JRE.");
                }
                return null;
            }
            Font font = Font.decode(family + "-" + this.getStyleAsString(style) + "-" + "240");
            fontSet = new FontSet(this.maxFacesPerFont);
            fontSet.put(font.getStyle(), new JREFontFace(font, font.getStyle(), this.maxGlyphsPerFace, null, null, null, useTwips));
        }
        return fontSet;
    }

    public FontFace getEntryFromSystem(String familyName, int style, boolean useTwips) {
        if (!this.readLocalFonts) {
            this.readLocalFonts();
        }
        FontFace entry = null;
        FontSet fontSet = (FontSet)this.getFontCache().get(familyName);
        if (fontSet == null) {
            fontSet = this.createSetForSystemFont(familyName, style, useTwips);
        }
        if (fontSet != null) {
            entry = fontSet.get(style);
        }
        if (entry != null) {
            LocalFont font = this.localFonts.get(entry.getPostscriptName());
            if (font == null) {
                if (Trace.font) {
                    Trace.trace("Information on font " + familyName + " could not be found.  Run FontSnapshot to get a list of the current local fonts.");
                }
            } else {
                entry.setCopyright(font.copyright);
                entry.setTrademark(font.trademark);
                entry.setFSType(FSType.getFSType(font.fsType));
            }
        }
        return entry;
    }

    private void readLocalFonts() {
        block4: {
            this.readLocalFonts = true;
            this.localFonts = new HashMap<String, LocalFont>();
            try {
                BufferedInputStream buffStream = new BufferedInputStream(new FileInputStream(this.localFontsFile));
                ObjectInputStream in = new ObjectInputStream(buffStream);
                Map customLocalFonts = (Map)in.readObject();
                this.localFonts.putAll(customLocalFonts);
            }
            catch (FileNotFoundException fnfe) {
                if (Trace.font) {
                    fnfe.printStackTrace();
                }
            }
            catch (Exception fnfe) {
                if (!Trace.font) break block4;
                Trace.trace("Could not read localFonts.ser: " + fnfe);
            }
        }
    }

    private String getStyleAsString(int style) {
        String styleName;
        switch (style) {
            case 1: {
                styleName = "bold";
                break;
            }
            case 2: {
                styleName = "italic";
                break;
            }
            case 3: {
                styleName = "bolditalic";
                break;
            }
            default: {
                styleName = "plain";
            }
        }
        return styleName;
    }

    private static void initializeSystemFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fnts = ge.getAvailableFontFamilyNames();
        if (fnts != null) {
            systemFontNames = new ArrayList(fnts.length);
            for (int i = 0; i < fnts.length; ++i) {
                systemFontNames.add(fnts[i].trim().toLowerCase());
            }
        }
    }

    public static class JREFontFace
    extends CachedFontFace {
        private Font font;
        private static Graphics2D graphics;
        private FontRenderContext frc;
        private FontMetrics fontMetrics;
        private int ascent;
        private int descent;
        private int lineGap;
        private double emScale;
        private AffineTransform scaleTransform;

        public JREFontFace(Font font, int style, int maxGlyph, FSType fsType, String copyright, String trademark, boolean useTwips) {
            super(maxGlyph, style, fsType, copyright, trademark, useTwips);
            this.font = font;
            this.init();
        }

        private void init() {
            this.emScale = 1024.0 / this.getPointSize();
            this.scaleTransform = new AffineTransform();
            this.scaleTransform.setToScale(this.emScale, this.emScale);
            if (graphics == null) {
                BufferedImage bi = new BufferedImage(50, 50, 1);
                graphics = bi.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.fontMetrics = graphics.getFontMetrics(this.font);
            this.frc = new FontRenderContext(null, true, false);
            this.ascent = (int)Math.rint((double)this.fontMetrics.getAscent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.descent = (int)Math.rint((double)this.fontMetrics.getDescent() * this.emScale * (double)(this.useTwips ? 20 : 1));
            this.lineGap = (int)Math.rint(Math.abs(this.getPointSize() - (double)this.ascent - (double)this.descent));
        }

        public boolean canDisplay(char c2) {
            return this.font.canDisplay(c2);
        }

        public String getFamily() {
            return this.font.getName();
        }

        public int getFirstChar() {
            return 0;
        }

        public GlyphEntry getGlyphEntry(char c2) {
            return (GlyphEntry)this.glyphCache.get(c2);
        }

        protected GlyphEntry createGlyphEntry(char c2) {
            return this.createGlyphEntry(c2, c2);
        }

        public GlyphEntry createGlyphEntry(char c2, char referenceChar) {
            flash.swf.types.Shape swfShape = null;
            int advance = 0;
            GlyphVector gv = this.font.createGlyphVector(this.frc, new char[]{referenceChar});
            Shape glyphOutline = gv.getGlyphOutline(0);
            GlyphMetrics metrics = gv.getGlyphMetrics(0);
            advance = (int)Math.rint(metrics.getAdvance());
            Shape scaledShape = this.scaleTransform.createTransformedShape(glyphOutline);
            swfShape = this.createGlyphShape(scaledShape);
            GlyphEntry ge = new GlyphEntry();
            ge = new GlyphEntry();
            ge.advance = (int)((double)advance * this.emScale * (double)(this.useTwips ? 20 : 1));
            ge.shape = swfShape;
            ge.character = c2;
            return ge;
        }

        private flash.swf.types.Shape createGlyphShape(Shape outline) {
            ShapeBuilder shape = new ShapeBuilder(this.useTwips);
            shape.setCurrentLineStyle(0);
            shape.setCurrentFillStyle1(1);
            shape.setUseFillStyle1(true);
            shape.processShape(new PathIteratorWrapper(outline.getPathIterator(null)));
            return shape.build();
        }

        public int getAdvance(char c2) {
            return 0;
        }

        public Font getFont() {
            return this.font;
        }

        public int getMissingGlyphCode() {
            return this.font.getMissingGlyphCode();
        }

        public double getPointSize() {
            return this.font.getSize2D();
        }

        public FontRenderContext getFontRenderContext() {
            return this.frc;
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getNumGlyphs() {
            return this.font.getNumGlyphs();
        }

        public double getEmScale() {
            return this.emScale;
        }

        public String getPostscriptName() {
            return this.font.getPSName();
        }
    }
}

