/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.swf.types.GlyphEntry;
import flash.util.IntMapLRUCache;

public abstract class CachedFontFace
extends FontFace {
    protected int style;
    protected FSType fsType;
    protected String copyright;
    protected String trademark;
    public boolean useTwips;
    public static final short GLYPH_CACHE_PURGE = 10;
    public final GlyphCache glyphCache;

    protected CachedFontFace(int maxCachedGlyphs) {
        this.glyphCache = new GlyphCache(this, maxCachedGlyphs / 5, maxCachedGlyphs, 10);
    }

    protected CachedFontFace(int maxCachedGlyphs, int style, FSType fsType, String copyright, String trademark, boolean useTwips) {
        this(maxCachedGlyphs);
        this.style = style;
        this.fsType = fsType;
        this.copyright = copyright;
        this.trademark = trademark;
        this.useTwips = useTwips;
    }

    public boolean isBold() {
        return CachedFontFace.isBold(this.style);
    }

    public boolean isItalic() {
        return CachedFontFace.isItalic(this.style);
    }

    public FSType getFSType() {
        return this.fsType;
    }

    public void setFSType(FSType t) {
        this.fsType = t;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String c2) {
        this.copyright = c2;
    }

    public String getTrademark() {
        return this.trademark;
    }

    public void setTrademark(String t) {
        this.trademark = t;
    }

    public static boolean isBold(int style) {
        return style == 1 || style == 3;
    }

    public static boolean isItalic(int style) {
        return style == 2 || style == 3;
    }

    public static int guessStyleFromSubFamilyName(String subFamilyName) {
        int style = 0;
        if (subFamilyName != null) {
            if ((subFamilyName = subFamilyName.toLowerCase()).indexOf("regular") != -1) {
                style = 0;
            }
            if (subFamilyName.indexOf("bold") != -1) {
                ++style;
            }
            if (subFamilyName.indexOf("italic") != -1 || subFamilyName.indexOf("oblique") != -1) {
                style += 2;
            }
        }
        return style;
    }

    protected abstract GlyphEntry createGlyphEntry(char var1);

    protected abstract GlyphEntry createGlyphEntry(char var1, char var2);

    static class GlyphCache
    extends IntMapLRUCache {
        private CachedFontFace fontFace;

        GlyphCache(CachedFontFace face, int initialSize, int maxSize, int purgeSize) {
            super(initialSize, maxSize, purgeSize);
            this.fontFace = face;
        }

        public Object fetch(int key) {
            char c2 = (char)key;
            if (this.fontFace.canDisplay(c2)) {
                return this.fontFace.createGlyphEntry(c2, c2);
            }
            return null;
        }
    }
}

