/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf;

import com.adobe.fxg.FXGVersion;
import com.adobe.internal.fxg.dom.ScalableGradientNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.FillMode;
import com.adobe.internal.fxg.types.FXGMatrix;
import flash.swf.tags.DefineBits;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;

public class TypeHelper {
    public static final double GRADIENT_DIMENSION = 1638.4;

    public static Rect rect(double minX, double minY, double maxX, double maxY) {
        Rect rect = new Rect();
        rect.xMin = (int)(minX * 20.0);
        rect.yMin = (int)(minY * 20.0);
        rect.xMax = (int)(maxX * 20.0);
        rect.yMax = (int)(maxY * 20.0);
        return rect;
    }

    public static Rect rect(double width, double height) {
        Rect rect = new Rect();
        rect.xMax = (int)(width * 20.0);
        rect.yMax = (int)(height * 20.0);
        return rect;
    }

    public static Matrix radialGradientMatrix(ScalableGradientNode gradient, Rect pathBounds) {
        MatrixNode mtxNode = gradient.getMatrixNode();
        if (mtxNode != null) {
            double tx = mtxNode.tx;
            double ty = mtxNode.ty;
            FXGMatrix fxgMtx = new FXGMatrix(mtxNode.a, mtxNode.b, mtxNode.c, mtxNode.d, 0.0, 0.0);
            fxgMtx.scale(6.103515625E-4, 6.103515625E-4);
            fxgMtx.translate(tx, ty);
            return fxgMtx.toSWFMatrix();
        }
        double w = !Double.isNaN(gradient.getScaleX()) ? gradient.getScaleX() * 20.0 : (double)pathBounds.getWidth();
        double h2 = !Double.isNaN(gradient.getScaleY()) ? gradient.getScaleY() * 20.0 : (double)pathBounds.getHeight();
        double tx = !Double.isNaN(gradient.getX()) ? gradient.getX() : (double)(pathBounds.xMax + pathBounds.xMin) / 40.0;
        double ty = !Double.isNaN(gradient.getY()) ? gradient.getY() : (double)(pathBounds.yMax + pathBounds.yMin) / 40.0;
        FXGMatrix matrix = new FXGMatrix();
        matrix.scale(w / 32768.0, h2 / 32768.0);
        if (!Double.isNaN(gradient.getRotation()) && gradient.getRotation() != 0.0) {
            matrix.rotate(gradient.getRotation());
        }
        matrix.translate(tx, ty);
        return matrix.toSWFMatrix();
    }

    public static Matrix linearGradientMatrix(ScalableGradientNode gradient, Rect pathBounds) {
        FXGMatrix matrix = new FXGMatrix();
        MatrixNode mtxNode = gradient.getMatrixNode();
        if (mtxNode != null) {
            matrix.translate(819.2, 819.2);
            matrix.scale(6.103515625E-4, 6.103515625E-4);
            FXGMatrix nodeMatrix = new FXGMatrix(mtxNode);
            matrix.concat(nodeMatrix);
            return matrix.toSWFMatrix();
        }
        double width = (double)(pathBounds.xMax - pathBounds.xMin) / 20.0;
        double height = (double)(pathBounds.yMax - pathBounds.yMin) / 20.0;
        double scaleX = gradient.getScaleX();
        double rotation = gradient.getRotation();
        double tx = gradient.getX();
        double ty = gradient.getY();
        if (Double.isNaN(scaleX)) {
            if (rotation % 90.0 != 0.0) {
                double normalizedAngle = rotation % 360.0;
                if (normalizedAngle < 0.0) {
                    normalizedAngle += 360.0;
                }
                if ((normalizedAngle %= 180.0) > 90.0) {
                    normalizedAngle = 180.0 - normalizedAngle;
                }
                double side = width;
                double hypotenuse = Math.sqrt(width * width + height * height);
                double hypotenuseAngle = Math.acos(width / hypotenuse) * 180.0 / Math.PI;
                if (normalizedAngle > hypotenuseAngle) {
                    normalizedAngle = 90.0 - normalizedAngle;
                    side = height;
                }
                scaleX = side / Math.cos(normalizedAngle / 180.0 * Math.PI);
            } else {
                double d2 = scaleX = rotation % 180.0 == 0.0 ? width : height;
            }
        }
        if (!Double.isNaN(tx) && Double.isNaN(ty)) {
            ty = 0.0;
        }
        if (Double.isNaN(tx) && !Double.isNaN(ty)) {
            tx = 0.0;
        }
        if (!Double.isNaN(tx) && !Double.isNaN(ty)) {
            matrix.translate(819.2, 819.2);
        }
        if (Math.abs(scaleX) < 2.0) {
            scaleX = scaleX < 0.0 ? -2.0 : 2.0;
        }
        scaleX = scaleX * 20.0 / 32768.0;
        matrix.scale(scaleX, 1.0);
        if (!Double.isNaN(rotation)) {
            matrix.rotate(rotation);
        }
        if (Double.isNaN(tx)) {
            tx = width / 2.0 + (double)pathBounds.xMin / 20.0;
        }
        if (Double.isNaN(ty)) {
            ty = height / 2.0 + (double)pathBounds.yMin / 20.0;
        }
        matrix.translate(tx, ty);
        return matrix.toSWFMatrix();
    }

    public static FXGMatrix bitmapFillMatrix(BitmapFillNode fill, DefineBits img, Rect pathBounds) {
        double scaleY;
        double scaleX;
        double ty;
        double tx;
        MatrixNode mtxNode = fill.matrix;
        if (mtxNode != null) {
            double tx2 = mtxNode.tx;
            double ty2 = mtxNode.ty;
            FXGMatrix fxgMtx = new FXGMatrix(mtxNode.a, mtxNode.b, mtxNode.c, mtxNode.d, 0.0, 0.0);
            fxgMtx.scale(20.0, 20.0);
            fxgMtx.translate(tx2, ty2);
            return fxgMtx;
        }
        FXGMatrix matrix = new FXGMatrix();
        if (fill.getFileVersion() != FXGVersion.v1_0 && fill.fillMode.equals((Object)FillMode.SCALE)) {
            tx = Double.isNaN(fill.x) ? (double)pathBounds.xMin / 20.0 : fill.x;
            ty = Double.isNaN(fill.y) ? (double)pathBounds.yMin / 20.0 : fill.y;
            scaleX = Double.isNaN(fill.scaleX) ? (double)pathBounds.getWidth() / (double)img.width : 20.0 * fill.scaleX;
            scaleY = Double.isNaN(fill.scaleY) ? (double)pathBounds.getHeight() / (double)img.height : 20.0 * fill.scaleY;
        } else {
            tx = Double.isNaN(fill.x) ? (double)pathBounds.xMin / 20.0 : fill.x;
            ty = Double.isNaN(fill.y) ? (double)pathBounds.yMin / 20.0 : fill.y;
            scaleX = Double.isNaN(fill.scaleX) ? 20.0 : 20.0 * fill.scaleX;
            scaleY = Double.isNaN(fill.scaleY) ? 20.0 : 20.0 * fill.scaleY;
        }
        for (double angle = fill.rotation; angle < 0.0; angle += 360.0) {
        }
        matrix.scale(scaleX, scaleY);
        matrix.rotate(angle %= 360.0);
        matrix.translate(tx, ty);
        return matrix;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier) {
        CXFormWithAlpha c2 = new CXFormWithAlpha();
        c2.hasMult = true;
        c2.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        return c2;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier, double redMultiplier, double greenMultiplier, double blueMultiplier, double alphaOffset, double redOffset, double greenOffset, double blueOffset) {
        CXFormWithAlpha c2 = new CXFormWithAlpha();
        c2.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        c2.redMultTerm = TypeHelper.fixed8(redMultiplier);
        c2.greenMultTerm = TypeHelper.fixed8(greenMultiplier);
        c2.blueMultTerm = TypeHelper.fixed8(blueMultiplier);
        c2.alphaAddTerm = (int)alphaOffset;
        c2.redAddTerm = (int)redOffset;
        c2.greenAddTerm = (int)greenOffset;
        c2.blueAddTerm = (int)blueOffset;
        if (c2.alphaAddTerm > 0 || c2.redAddTerm > 0 || c2.greenAddTerm > 0 || c2.blueAddTerm > 0) {
            c2.hasAdd = true;
        }
        if (c2.alphaMultTerm > 0 || c2.redMultTerm > 0 || c2.greenMultTerm > 0 || c2.blueMultTerm > 0) {
            c2.hasMult = true;
        }
        return c2;
    }

    public static int gradientRatio(double ratio) {
        return (int)StrictMath.rint(ratio * 255.0);
    }

    public static int colorARGB(int color, double alpha) {
        int rgb = color & 0xFFFFFF;
        int a2 = (int)StrictMath.rint(alpha * 255.0);
        int argb = rgb | a2 << 24;
        return argb;
    }

    public static int fixed(double value) {
        return (int)(value * 65536.0);
    }

    public static int fixed8(double value) {
        return (int)(value * 256.0) & 0xFFFF;
    }
}

