/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.internal.fxg.dom.types.NumberPercentAuto;

public class ImgNode
extends AbstractRichTextLeafNode {
    public NumberPercentAuto width = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public NumberPercentAuto height = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public String source = "";

    public String getNodeName() {
        return "img";
    }

    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = this.getNumberPercentAuto(this, name, value, "UnknownImgWidth");
        } else if ("height".equals(name)) {
            this.height = this.getNumberPercentAuto(this, name, value, "UnknownImgHeight");
        } else if ("source".equals(name)) {
            this.source = value;
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private NumberPercentAuto getNumberPercentAuto(FXGNode node, String name, String value, String errorCode) {
        try {
            double valueDbl = DOMParserHelper.parsePercent(this, value, name);
            return NumberPercentAuto.newInstance(valueDbl);
        }
        catch (FXGException e2) {
            if ("auto".equals(value)) {
                return NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }
}

