/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.types.FillMode;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DOMParserHelper {
    private static Pattern idPattern = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    private static Pattern rgbPattern = Pattern.compile("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]");

    public static boolean parseBoolean(FXGNode node, String value, String name) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidBooleanValue", name, value);
    }

    public static int parseRGB(FXGNode node, String value, String name) {
        Matcher m = rgbPattern.matcher(value);
        if (!m.matches()) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidColorValue", name, value);
        }
        value = value.substring(1);
        int a2 = 255;
        int r = Integer.parseInt(value.substring(0, 2), 16) & 0xFF;
        int g2 = Integer.parseInt(value.substring(2, 4), 16) & 0xFF;
        int b2 = Integer.parseInt(value.substring(4, 6), 16) & 0xFF;
        return a2 << 24 | r << 16 | g2 << 8 | b2;
    }

    public static double parseDouble(FXGNode node, String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e2) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidDoubleValue", name, value);
        }
    }

    public static double parsePercent(FXGNode node, String value, String name) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            String doubleValue = value.substring(0, value.length() - 1);
            try {
                return DOMParserHelper.parseDouble(node, doubleValue, name);
            }
            catch (FXGException e2) {
                throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidPercentValue", name, value);
            }
        }
        return DOMParserHelper.parseDouble(node, value, name);
    }

    public static double parseNumberPercent(FXGNode node, String value, String name, double min, double max, double defaultValue) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            String doubleValue = value.substring(0, value.length() - 1);
            try {
                return DOMParserHelper.parseDouble(node, doubleValue, name, min, max, defaultValue);
            }
            catch (FXGException e2) {
                throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidPercentValue", name, value);
            }
        }
        return DOMParserHelper.parseDouble(node, value, name, min, max, defaultValue);
    }

    public static double parseNumberPercentWithSeparateRange(FXGNode node, String value, String name, double minNumber, double maxNumber, double minPercent, double maxPercent, double defaultValue) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            String doubleValue = value.substring(0, value.length() - 1);
            try {
                return DOMParserHelper.parseDouble(node, doubleValue, name, minPercent, maxPercent, defaultValue);
            }
            catch (FXGException e2) {
                throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidPercentValue", name, value);
            }
        }
        return DOMParserHelper.parseDouble(node, value, name, minNumber, maxNumber, defaultValue);
    }

    public static double parseDouble(FXGNode node, String value, String name, double min, double max, double defaultValue) {
        try {
            double d2 = Double.parseDouble(value);
            if (d2 >= min && d2 <= max) {
                return d2;
            }
        }
        catch (NumberFormatException e2) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidDoubleValue", name, value);
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), defaultValue, name);
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "OutOfRangeValue", name, value, min, max);
    }

    public static float parseFloat(FXGNode node, String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e2) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidFloatValue", value);
        }
    }

    public static int parseInt(FXGNode node, String value, String name, int min, int max, int defaultValue) {
        int i = DOMParserHelper.parseInt(node, value, name);
        if (i >= min && i <= max) {
            return i;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), defaultValue, name);
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "OutOfRangeValue", value, min, max);
    }

    public static int parseInt(FXGNode node, String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e2) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidIntegerValue", name, value);
        }
    }

    public static InterpolationMethod parseInterpolationMethod(FXGNode node, String value, String name, InterpolationMethod defaultValue) {
        if ("rgb".equals(value)) {
            return InterpolationMethod.RGB;
        }
        if ("linearRGB".equals(value)) {
            return InterpolationMethod.LINEAR_RGB;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), new Object[]{defaultValue, name});
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownInterpolationMethod", value);
    }

    public static MaskType parseMaskType(FXGNode node, String value, String name, MaskType defaultValue) {
        if ("clip".equals(value)) {
            return MaskType.CLIP;
        }
        if ("alpha".equals(value)) {
            return MaskType.ALPHA;
        }
        if (((AbstractFXGNode)node).getFileVersion().equalTo(FXGVersion.v1_0)) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownMaskType", value);
        }
        if ("luminosity".equals(value)) {
            return MaskType.LUMINOSITY;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), new Object[]{defaultValue, name});
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownMaskType", value);
    }

    public static FillMode parseFillMode(FXGNode node, String value, String name, FillMode defaultValue) {
        if ("clip".equals(value)) {
            return FillMode.CLIP;
        }
        if ("repeat".equals(value)) {
            return FillMode.REPEAT;
        }
        if ("scale".equals(value)) {
            return FillMode.SCALE;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), new Object[]{defaultValue, name});
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFillMode", value);
    }

    public static SpreadMethod parseSpreadMethod(FXGNode node, String value, String name, SpreadMethod defaultValue) {
        if ("pad".equals(value)) {
            return SpreadMethod.PAD;
        }
        if ("reflect".equals(value)) {
            return SpreadMethod.REFLECT;
        }
        if ("repeat".equals(value)) {
            return SpreadMethod.REPEAT;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), new Object[]{defaultValue, name});
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownSpreadMethod", value);
    }

    public static String parseIdentifier(FXGNode node, String value, String name, String defaultValue) {
        Matcher m = idPattern.matcher(value);
        if (m.matches()) {
            return value;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentName(), node.getStartLine(), node.getStartColumn(), defaultValue, name);
            return defaultValue;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "InvalidIdentifierFormat", value);
    }
}

