/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Symtab;
import adobe.abc.TypeCache;
import adobe.abc.Typeref;

public class Type {
    Name name;
    public Type base;
    Type[] interfaces = OptimizerConstants.notypes;
    Symtab<Binding> defs;
    Method init;
    Type itype;
    int flags;
    Namespace protectedNs;
    Typeref[] scopes = OptimizerConstants.notyperefs;
    boolean numeric;
    boolean primitive;
    boolean atom;
    Object defaultValue;
    public Typeref ref = new Typeref(this, true);
    int size;
    int slotCount;
    int ctype;
    boolean obscure_natives = false;

    Type() {
        this.defaultValue = TypeCache.instance().NULL;
        this.ctype = 8;
    }

    Type(Name name, Type base) {
        this();
        this.name = name;
        this.base = base;
        this.defs = new Symtab();
        this.obscure_natives = false;
    }

    boolean emitAsAny() {
        return this.base == null && this != TypeCache.instance().VOID && this.defs.size() == 0 && !TypeCache.instance().builtinTypes.contains(this) && !TypeCache.instance().baseTypes.contains(this);
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    public boolean isFinal() {
        return (this.flags & 2) != 0;
    }

    void setFinal() {
        this.flags |= 2;
    }

    Binding find(Name n) {
        Type t = this;
        while (t != null) {
            Binding b2 = t.defs.get(n);
            if (b2 != null) {
                return b2;
            }
            t = t.base;
        }
        return null;
    }

    Binding findGet(Name n) {
        Binding first = this.find(n);
        if (first != null && GlobalOptimizer.isSetter(first)) {
            Binding second;
            if (first.peer != null) {
                return first.peer;
            }
            if (this.base != null && GlobalOptimizer.isGetter(second = this.base.findGet(n))) {
                return second;
            }
        }
        return first;
    }

    public Binding findSlot(int slot) {
        for (Binding b2 : this.defs.values()) {
            if (!GlobalOptimizer.isSlot(b2) || b2.slot != slot) continue;
            return b2;
        }
        return null;
    }

    public boolean hasProtectedNs() {
        return (this.flags & 8) != 0;
    }

    boolean isMachineCompatible(Type t) {
        boolean result = this.equals(t);
        result |= this.equals(TypeCache.instance().NULL) && !t.isMachineType();
        result |= t.equals(TypeCache.instance().NULL) && !this.isMachineType();
        return result |= !this.isMachineType() && !t.isMachineType() && !this.equals(TypeCache.instance().ANY) && !t.equals(TypeCache.instance().ANY);
    }

    boolean isMachineType() {
        return this.equals(TypeCache.instance().OBJECT) || this.equals(TypeCache.instance().VOID) || this.equals(TypeCache.instance().INT) || this.equals(TypeCache.instance().UINT) || this.equals(TypeCache.instance().BOOLEAN) || this.equals(TypeCache.instance().ARRAY) || this.equals(TypeCache.instance().NUMBER);
    }

    public boolean isAtom() {
        return this.atom;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean extendsOrIsBase(Type c2) {
        return this == c2 || this.extendsBase(c2);
    }

    public boolean extendsBase(Type c2) {
        Type t = this.base;
        while (t != null) {
            if (t == c2) {
                return true;
            }
            t = t.base;
        }
        return false;
    }

    public boolean implementsInterface(Type i) {
        for (Type x : this.interfaces) {
            if (x != i) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFrom(Type x) {
        return this.extendsBase(x) || this.implementsInterface(x);
    }
}

