/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Handler;
import adobe.abc.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
implements Comparable<Edge> {
    public Block from;
    public Block to;
    int label;
    int id;
    Handler handler;
    boolean is_backwards_branch = false;

    Edge(Method m, Block f2, int i) {
        this.from = f2;
        this.label = i;
        this.id = m.edgeId++;
    }

    public Edge(Method m, Block f2, int i, Block t) {
        this(m, f2, i);
        this.to = t;
    }

    Edge(Method m, Block f2, int i, Handler h2) {
        this(m, f2, i);
        this.handler = h2;
    }

    public boolean isBackedge() {
        return this.from.postorder < this.to.postorder;
    }

    public int hashCode() {
        return this.label ^ this.to.hashCode() ^ (this.from != null ? this.from.hashCode() : 0);
    }

    public boolean equals(Object o) {
        return o instanceof Edge && ((Edge)o).from == this.from && ((Edge)o).to == this.to && ((Edge)o).label == this.label;
    }

    public String toString() {
        return (this.isThrowEdge() ? this.handler.toString() + " " : "") + (this.from != null ? this.label + ":" + this.from : "") + "->" + this.to;
    }

    @Override
    public int compareTo(Edge e2) {
        int d2 = this.label - e2.label;
        if (d2 != 0) {
            return d2;
        }
        if (this.from != null && e2.from == null) {
            return 1;
        }
        if (this.from == null && e2.from != null) {
            return -1;
        }
        if (this.from != null && (d2 = this.from.compareTo(e2.from)) != 0) {
            return d2;
        }
        return this.to.compareTo(e2.to);
    }

    public boolean isThrowEdge() {
        return this.handler != null;
    }

    public int getLabel() {
        return this.label;
    }
}

