/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraph {
    GlobalOptimizer.InputAbc abc;

    CallGraph(GlobalOptimizer.InputAbc abc) {
        this.abc = abc;
    }

    public List<Method> traverseDepthFirstUnique() {
        ArrayList<Method> traversed_methods = new ArrayList<Method>();
        for (Type t : this.abc.scripts) {
            this.searchType(t, traversed_methods);
        }
        return traversed_methods;
    }

    private void searchType(Type t, List<Method> traversed_methods) {
        this.searchMethod(t.init, traversed_methods);
        for (Binding b1 : t.defs.values()) {
            if (b1.method == null) continue;
            this.searchMethod(b1.method, traversed_methods);
        }
    }

    private void searchMethod(Method m, List<Method> traversed_methods) {
        if (traversed_methods.contains(m)) {
            return;
        }
        traversed_methods.add(m);
        for (Block b2 : Algorithms.dfs(m.entry.to)) {
            for (Expr e2 : b2.exprs) {
                switch (e2.op) {
                    case 88: {
                        this.searchType(e2.c, traversed_methods);
                        this.searchType(e2.c.itype, traversed_methods);
                        break;
                    }
                    case 64: {
                        Method f2 = e2.m;
                        this.searchMethod(f2, traversed_methods);
                        break;
                    }
                }
            }
        }
    }
}

