/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.abc.OptimizerConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Iterable<Expr>,
Comparable<Block> {
    public Algorithms.Deque<Expr> exprs = new Algorithms.ArrayDeque<Expr>();
    Set<Expr> live_out = new HashSet<Expr>();
    public int id;
    public int postorder;
    public Edge[] xsucc = OptimizerConstants.noedges;
    boolean must_isolate_block = false;
    boolean is_backwards_branch_target = false;

    public Block(Method m) {
        this.id = m.getNextBlockId();
    }

    public void appendExpr(Expr e2) {
        if (this.exprs.peekLast().succ != null) {
            Expr last = this.exprs.removeLast();
            this.exprs.add(e2);
            this.exprs.add(last);
        } else {
            this.exprs.add(e2);
        }
    }

    public void killRegister(Method m, int regnum) {
        this.appendExpr(new Expr(m, 8, regnum));
    }

    public String toString() {
        return 'B' + String.valueOf(this.id);
    }

    public Expr first() {
        return this.exprs.peekFirst();
    }

    public Expr last() {
        return this.exprs.peekLast();
    }

    public Edge[] succ() {
        if (this.last().succ != null) {
            return this.last().succ;
        }
        return OptimizerConstants.noedges;
    }

    @Override
    public Iterator<Expr> iterator() {
        return this.exprs.iterator();
    }

    public void add(Expr e2) {
        this.exprs.add(e2);
    }

    void addAll(Block b2) {
        this.exprs.addAll(b2.exprs);
    }

    public boolean isEmpty() {
        return this.exprs.isEmpty();
    }

    public int size() {
        return this.exprs.size();
    }

    public void remove(Expr e2) {
        this.exprs.remove(e2);
    }

    @Override
    public int compareTo(Block b2) {
        return this.id - b2.id;
    }

    public void addLiveOut(Expr e2) {
        assert (this.exprs.contains(e2));
        this.live_out.add(e2);
    }

    public Set<Expr> getLiveOut() {
        return this.live_out;
    }
}

