/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithms {
    public static Set<Integer> foreach(BitSet x) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i = 0; i < x.length(); ++i) {
            if (!x.get(i)) continue;
            result.add(i);
        }
        return result;
    }

    public static Map<Block, Block> idoms(Deque<Block> all, SetMap<Block, Edge> pred) {
        boolean changed;
        Block entry = all.peekFirst();
        Block[] doms = new Block[entry.postorder + 1];
        doms[entry.postorder] = entry;
        do {
            changed = false;
            for (Block b2 : all) {
                Block p;
                Edge e2;
                if (b2 == entry) continue;
                Block new_idom = null;
                Iterator i$ = pred.get(b2).iterator();
                while (i$.hasNext()) {
                    e2 = (Edge)i$.next();
                    p = e2.from;
                    if (doms[p.postorder] == null) continue;
                    new_idom = p;
                    break;
                }
                i$ = pred.get(b2).iterator();
                while (i$.hasNext()) {
                    e2 = (Edge)i$.next();
                    p = e2.from;
                    if (p == new_idom || doms[p.postorder] == null) continue;
                    new_idom = Algorithms.intersect(p, new_idom, doms);
                }
                if (doms[b2.postorder] == new_idom) continue;
                doms[b2.postorder] = new_idom;
                changed = true;
            }
        } while (changed);
        TreeMap<Block, Block> map = new TreeMap<Block, Block>();
        for (Block b3 : all) {
            if (b3 == entry) continue;
            map.put(b3, doms[b3.postorder]);
        }
        return map;
    }

    public static Block intersect(Block b1, Block b2, Block[] doms) {
        while (b1 != b2) {
            while (b1.postorder < b2.postorder) {
                b1 = doms[b1.postorder];
            }
            while (b2.postorder < b1.postorder) {
                b2 = doms[b2.postorder];
            }
        }
        return b1;
    }

    public static boolean dominates(Block p, Block s, Map<Block, Block> idom) {
        Block b2 = s;
        while (b2 != null) {
            if (b2 == p) {
                return true;
            }
            b2 = idom.get(b2);
        }
        return false;
    }

    public static SetMap<Block, Edge> preds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b2 : code) {
            for (Edge s : b2.succ()) {
                pred.get(s.to).add(s);
            }
        }
        return pred;
    }

    static void checkPredecessors(SetMap<Block, Edge> pred, Deque<Block> code) {
        block0: for (Block b2 : code) {
            for (Expr e2 : b2) {
                if (e2.op != 10) continue block0;
                TreeSet<Edge> phi_in = new TreeSet<Edge>();
                for (Edge p : e2.pred) {
                    phi_in.add(p);
                }
                Object blk_in = pred.get(b2);
                assert (((Object)phi_in).equals(blk_in));
            }
        }
    }

    static SetMap<Block, Edge> allpreds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b2 : code) {
            for (Edge s : b2.succ()) {
                pred.get(s.to).add(s);
            }
            for (Edge x : b2.xsucc) {
                pred.get(x.to).add(x);
            }
        }
        return pred;
    }

    public static EdgeMap<Expr> findUses(Deque<Block> code) {
        EdgeMap<Expr> uses = new EdgeMap<Expr>();
        for (Block b2 : code) {
            for (Expr e2 : b2) {
                for (Expr a2 : e2.args) {
                    uses.get(a2).add(e2);
                }
                for (Expr a2 : e2.locals) {
                    uses.get(a2).add(e2);
                }
                for (Expr a2 : e2.scopes) {
                    uses.get(a2).add(e2);
                }
            }
        }
        return uses;
    }

    private static void dfs_visit_el(Edge[] el, BitSet visited, Deque<Block> list) {
        for (int i = el.length - 1; i >= 0; --i) {
            Algorithms.dfs_visit(el[i].to, visited, list);
        }
    }

    private static Deque<Block> dfs_visit(Block b2, BitSet visited, Deque<Block> list) {
        if (!visited.get(b2.id)) {
            visited.set(b2.id);
            Algorithms.dfs_visit_el(b2.xsucc, visited, list);
            Algorithms.dfs_visit_el(b2.succ(), visited, list);
            b2.postorder = list.size();
            list.addFirst(b2);
        }
        return list;
    }

    public static Deque<Block> dfs(Block entry) {
        return Algorithms.dfs_visit(entry, new BitSet(), new LinkedDeque<Block>());
    }

    public static Block getBlock(Set<Block> work) {
        Iterator<Block> i = work.iterator();
        Block b2 = i.next();
        i.remove();
        return b2;
    }

    public static Expr getExpr(Set<Expr> work) {
        Iterator<Expr> i = work.iterator();
        Expr e2 = i.next();
        i.remove();
        return e2;
    }

    public static Edge getEdge(Set<Edge> work) {
        Iterator<Edge> i = work.iterator();
        Edge e2 = i.next();
        i.remove();
        return e2;
    }

    public static Method getMethod(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopologicalSort<T> {
        public List<T> toplogicalSort(List<T> unsorted, DependencyChecker<T> checker) {
            HashMap dep = new HashMap(unsorted.size());
            for (T x : unsorted) {
                HashSet<T> parents = new HashSet<T>();
                dep.put(x, parents);
                for (T y : unsorted) {
                    if (x == y || !checker.depends(x, y)) continue;
                    if (checker.depends(y, x)) {
                        throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
                    }
                    parents.add(y);
                }
            }
            ArrayList sorted = new ArrayList(unsorted.size());
            while (dep.size() > 0) {
                boolean found_sorted_element = false;
                for (Object x : dep.keySet()) {
                    if (0 != ((Set)dep.get(x)).size()) continue;
                    sorted.add(x);
                    found_sorted_element = true;
                    for (T y : unsorted) {
                        if (!dep.containsKey(y)) continue;
                        ((Set)dep.get(y)).remove(x);
                    }
                    dep.remove(x);
                    break;
                }
                if (found_sorted_element) continue;
                throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
            }
            return sorted;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface DependencyChecker<T> {
            public boolean depends(T var1, T var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pool<T extends Comparable> {
        Map<T, Integer> refs = new HashMap<T, Integer>();
        ArrayList<T> values;
        int countFrom;

        Pool(int countFrom) {
            this.countFrom = countFrom;
        }

        int add(T e2) {
            int n = !this.refs.containsKey(e2) ? 1 : this.refs.get(e2) + 1;
            this.refs.put(e2, n);
            return n;
        }

        void sort() {
            Object[] arr = new Ranker[this.refs.size()];
            int i = 0;
            for (Comparable e2 : this.refs.keySet()) {
                arr[i++] = new Ranker<Comparable>(e2, this.refs.get(e2));
            }
            assert (i == this.refs.size());
            Arrays.sort(arr);
            this.values = new ArrayList();
            i = this.countFrom;
            for (Object r : arr) {
                this.values.add(((Ranker)r).value);
                this.refs.put(((Ranker)r).value, i++);
            }
        }

        int id(T e2) {
            assert (this.refs.containsKey(e2));
            assert (this.refs.get(e2) < this.size());
            return this.refs.get(e2);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Ranker<T>
        implements Comparable {
            T value;
            int rank;

            Ranker(T value, int rank) {
                this.value = value;
                this.rank = rank;
            }

            public int compareTo(Object o) {
                return ((Ranker)o).rank - this.rank;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayDeque<E>
    extends ArrayList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        public ArrayDeque() {
        }

        public ArrayDeque(Collection<E> c2) {
            this.addAll(c2);
        }

        @Override
        public void addFirst(E e2) {
            this.add(0, e2);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeMap<E>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<E> get(Object e2) {
            return super.get(e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetMap<K, V>
    extends TreeMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<V> get(Object e2) {
            TreeSet s = (TreeSet)super.get(e2);
            if (s == null) {
                s = new TreeSet();
                this.put(e2, s);
            }
            return s;
        }
    }
}

