/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.ant.types;

import com.adobe.flash.compiler.ant.config.IOptionSource;
import com.adobe.flash.compiler.ant.config.OptionSpec;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class FlexFileSet
extends FileSet
implements IOptionSource {
    protected final OptionSpec spec;
    protected final boolean includeDirs;
    protected boolean append;

    public FlexFileSet() {
        this(false);
    }

    public FlexFileSet(OptionSpec spec) {
        this(spec, false);
    }

    public FlexFileSet(boolean dirs) {
        this.spec = null;
        this.includeDirs = dirs;
        this.append = false;
    }

    public FlexFileSet(OptionSpec spec, boolean dirs) {
        this.spec = spec;
        this.includeDirs = dirs;
        this.append = false;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        if (this.hasSelectors() || this.hasPatterns()) {
            DirectoryScanner scanner = this.getDirectoryScanner(this.getProject());
            if (this.includeDirs) {
                this.addFiles(scanner.getBasedir(), scanner.getIncludedDirectories(), cmdline);
            }
            this.addFiles(scanner.getBasedir(), scanner.getIncludedFiles(), cmdline);
        } else if (this.spec != null) {
            cmdline.createArgument().setValue("-" + this.spec.getFullName() + this.equalString());
        }
    }

    protected void addFiles(File base, String[] files, Commandline cmdline) {
        FileUtils utils = FileUtils.getFileUtils();
        if (this.spec == null) {
            for (int i = 0; i < files.length; ++i) {
                cmdline.createArgument().setValue(utils.resolveFile(base, files[i]).getAbsolutePath());
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                cmdline.createArgument().setValue("-" + this.spec.getFullName() + this.equalString() + utils.resolveFile(base, files[i]).getAbsolutePath());
            }
        }
    }

    protected String equalString() {
        return this.append ? "+=" : "=";
    }
}

