/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.ant.config;

import com.adobe.flash.compiler.ant.config.ConfigVariable;
import com.adobe.flash.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.types.Commandline;

public final class ConfigBoolean
extends ConfigVariable {
    private boolean enabled;
    private boolean isSet;

    public ConfigBoolean(OptionSpec spec) {
        super(spec);
        this.enabled = false;
        this.isSet = false;
    }

    public ConfigBoolean(OptionSpec spec, boolean enabled) {
        super(spec);
        this.set(enabled);
    }

    public void set(boolean value) {
        this.enabled = value;
        this.isSet = true;
    }

    @Override
    public void set(String value) {
        this.enabled = this.parseValue(value);
        this.isSet = true;
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        if (this.isSet) {
            cmdline.createArgument(true).setValue("-" + this.spec.getFullName() + "=" + this.enabled);
        }
    }

    private boolean parseValue(String value) {
        return value.toLowerCase().matches("\\s*(true|yes|on)\\s*");
    }
}

