/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.ant;

import com.adobe.flash.compiler.ant.FlexTask;
import com.adobe.flash.compiler.ant.config.ConfigAppendString;
import com.adobe.flash.compiler.ant.config.ConfigBoolean;
import com.adobe.flash.compiler.ant.config.ConfigInt;
import com.adobe.flash.compiler.ant.config.ConfigString;
import com.adobe.flash.compiler.ant.config.ConfigVariable;
import com.adobe.flash.compiler.ant.config.IOptionSource;
import com.adobe.flash.compiler.ant.config.NestedAttributeElement;
import com.adobe.flash.compiler.ant.config.OptionSpec;
import com.adobe.flash.compiler.ant.types.DefaultScriptLimits;
import com.adobe.flash.compiler.ant.types.DefaultSize;
import com.adobe.flash.compiler.ant.types.FlexFileSet;
import com.adobe.flash.compiler.ant.types.FlexSWCFileSet;
import com.adobe.flash.compiler.ant.types.Fonts;
import com.adobe.flash.compiler.ant.types.Metadata;
import com.adobe.flash.compiler.ant.types.RuntimeSharedLibraryPath;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;

public final class MXMLCTask
extends FlexTask
implements DynamicConfigurator {
    private static final String TASK_NAME = "mxmlc";
    private static final String TOOL_JAR_FILE_NAME = "compiler.jar";
    private static final String TOOL_CLASS_NAME = "com.adobe.flash.compiler.clients.MXMLC";
    private static final String TOOL_METHOD_NAME = "staticMainNoExit";
    private static final String TOOL_FAILURE_METHOD_NAME = "isFatalFailure";
    private static final ConfigVariable[] CONFIG_VARIABLES = new ConfigVariable[]{new ConfigBoolean(new OptionSpec("benchmark")), new ConfigBoolean(new OptionSpec("compiler.accessible")), new ConfigBoolean(new OptionSpec("compiler.debug")), new ConfigBoolean(new OptionSpec("compiler.incremental")), new ConfigBoolean(new OptionSpec("compiler.mobile")), new ConfigBoolean(new OptionSpec("compiler.optimize")), new ConfigBoolean(new OptionSpec("compiler.report-invalid-styles-as-warnings")), new ConfigBoolean(new OptionSpec("compiler.report-missing-required-skin-parts-as-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-actionscript-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-binding-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-deprecation-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-invalid-css-property-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-unused-type-selector-warnings")), new ConfigBoolean(new OptionSpec("compiler.strict")), new ConfigBoolean(new OptionSpec("compiler.use-resource-bundle-metadata")), new ConfigBoolean(new OptionSpec("remove-unused-rsls")), new ConfigBoolean(new OptionSpec("use-network")), new ConfigBoolean(new OptionSpec("warnings")), new ConfigBoolean(new OptionSpec("compiler.allow-source-path-overlap")), new ConfigBoolean(new OptionSpec("compiler.as3")), new ConfigBoolean(new OptionSpec("compiler.doc")), new ConfigBoolean(new OptionSpec("compiler.es")), new ConfigBoolean(new OptionSpec("compiler.generate-abstract-syntax-tree")), new ConfigBoolean(new OptionSpec("compiler.headless-server")), new ConfigBoolean(new OptionSpec("compiler.isolate-styles")), new ConfigBoolean(new OptionSpec("compiler.keep-all-type-selectors")), new ConfigBoolean(new OptionSpec("compiler.keep-generated-actionscript", "keep")), new ConfigBoolean(new OptionSpec("compiler.verbose-stacktraces")), new ConfigBoolean(new OptionSpec("compiler.warn-array-tostring-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-assignment-within-conditional")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-array-cast")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-bool-assignment")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-date-cast")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-es3-type-method")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-es3-type-prop")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-nan-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-null-assignment")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-null-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-undefined-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-boolean-constructor-with-no-args")), new ConfigBoolean(new OptionSpec("compiler.warn-changes-in-resolve")), new ConfigBoolean(new OptionSpec("compiler.warn-class-is-sealed")), new ConfigBoolean(new OptionSpec("compiler.warn-const-not-initialized")), new ConfigBoolean(new OptionSpec("compiler.warn-constructor-returns-value")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-event-handler-error")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-function-error")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-property-error")), new ConfigBoolean(new OptionSpec("compiler.warn-duplicate-argument-names")), new ConfigBoolean(new OptionSpec("compiler.warn-duplicate-variable-def")), new ConfigBoolean(new OptionSpec("compiler.warn-for-var-in-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-import-hides-classes")), new ConfigBoolean(new OptionSpec("compiler.warn-instance-of-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-internal-error")), new ConfigBoolean(new OptionSpec("compiler.warn-level-not-supported")), new ConfigBoolean(new OptionSpec("compiler.warn-missing-namespace-decl")), new ConfigBoolean(new OptionSpec("compiler.warn-negative-uint-literal")), new ConfigBoolean(new OptionSpec("compiler.warn-no-constructor")), new ConfigBoolean(new OptionSpec("compiler.warn-no-explicit-super-call-in-constructor")), new ConfigBoolean(new OptionSpec("compiler.warn-no-type-decl")), new ConfigBoolean(new OptionSpec("compiler.warn-number-from-string-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-scoping-change-in-this")), new ConfigBoolean(new OptionSpec("compiler.warn-slow-text-field-addition")), new ConfigBoolean(new OptionSpec("compiler.warn-unlikely-function-value")), new ConfigBoolean(new OptionSpec("compiler.warn-xml-class-has-changed")), new ConfigBoolean(new OptionSpec("static-link-runtime-shared-libraries", "static-rsls")), new ConfigBoolean(new OptionSpec("verify-digests")), new ConfigBoolean(new OptionSpec("use-direct-blit")), new ConfigBoolean(new OptionSpec("use-gpu")), new ConfigBoolean(new OptionSpec("flex")), new ConfigBoolean(new OptionSpec("inline")), new ConfigString(new OptionSpec("compiler.actionscript-file-encoding")), new ConfigString(new OptionSpec("compiler.context-root")), new ConfigString(new OptionSpec("compiler.defaults-css-url")), new ConfigString(new OptionSpec("compiler.locale")), new ConfigString(new OptionSpec("compiler.mxml.compatibility-version")), new ConfigString(new OptionSpec("compiler.services")), new ConfigString(new OptionSpec("debug-password")), new ConfigString(new OptionSpec("dump-config")), new ConfigString(new OptionSpec("link-report")), new ConfigString(new OptionSpec("load-externs")), new ConfigString(new OptionSpec("output", "o")), new ConfigString(new OptionSpec("raw-metadata")), new ConfigString(new OptionSpec("resource-bundle-list")), new ConfigString(new OptionSpec("size-report")), new ConfigString(new OptionSpec("target-player")), new ConfigString(new OptionSpec("tools-locale")), new ConfigAppendString(new OptionSpec("configname")), new ConfigInt(new OptionSpec("default-background-color")), new ConfigInt(new OptionSpec("default-frame-rate")), new ConfigInt(new OptionSpec("swf-version"))};
    private static final OptionSpec NAMESPACE = new OptionSpec("compiler.namespaces.namespace");
    private static final OptionSpec LICENSE = new OptionSpec("licenses.license");
    private static final OptionSpec EXTERNS = new OptionSpec("externs");
    private static final OptionSpec INCLUDES = new OptionSpec("includes");
    private static final OptionSpec INCLUDE_RESOURCE_BUNDLES = new OptionSpec("include-resource-bundles", "ir");
    private static final OptionSpec RUNTIME_SHARED_LIBRARIES = new OptionSpec("runtime-shared-libraries", "rsl");
    private static final OptionSpec FRAME = new OptionSpec("frames.frame");
    private static final OptionSpec DEFINE = new OptionSpec("compiler.define");
    private static final OptionSpec EXTERNAL_LIBRARY_PATH = new OptionSpec("compiler.external-library-path", "el");
    private static final OptionSpec INCLUDE_LIBRARIES = new OptionSpec("compiler.include-libraries");
    private static final OptionSpec LIBRARY_PATH = new OptionSpec("compiler.library-path", "l");
    private static final OptionSpec SOURCE_PATH = new OptionSpec("compiler.source-path", "sp");
    private static final OptionSpec THEME = new OptionSpec("compiler.theme");
    private static final OptionSpec LOAD_CONFIG = new OptionSpec("load-config");
    private static final OptionSpec KEEP_AS3_METADATA = new OptionSpec("compiler.keep-as3-metadata");
    private static final OptionSpec FORCE_RSLS = new OptionSpec("runtime-shared-library-settings.force-rsls");
    private static final OptionSpec APPLICATION_DOMAIN = new OptionSpec("runtime-shared-library-settings.application-domain", "rsl-domain");
    private String file;
    private String output;
    private Metadata metadata;
    private Fonts fonts;
    private DefaultScriptLimits defaultScriptLimits;
    private DefaultSize defaultSize;
    private final List<IOptionSource> nestedFileSets;

    public MXMLCTask() {
        super(TASK_NAME, CONFIG_VARIABLES, TOOL_JAR_FILE_NAME, TOOL_CLASS_NAME, TOOL_METHOD_NAME, TOOL_FAILURE_METHOD_NAME);
        this.nestedAttribs = new ArrayList();
        this.nestedFileSets = new ArrayList<IOptionSource>();
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setOutput(File o) {
        this.setOutput(o.getAbsolutePath());
    }

    public void setOutput(String o) {
        this.output = o;
    }

    public Metadata createMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
            return this.metadata;
        }
        throw new BuildException("Only one nested <metadata> element is allowed in an mxmlc task.");
    }

    public Fonts createFonts() {
        if (this.fonts == null) {
            this.fonts = new Fonts(this);
            return this.fonts;
        }
        throw new BuildException("Only one nested <fonts> element is allowed in an mxmlc task.");
    }

    public NestedAttributeElement createNamespace() {
        return this.createElem(new String[]{"uri", "manifest"}, NAMESPACE);
    }

    public NestedAttributeElement createLicense() {
        return this.createElem(new String[]{"product", "serial-number"}, LICENSE);
    }

    public NestedAttributeElement createExterns() {
        return this.createElem("symbol", EXTERNS);
    }

    public NestedAttributeElement createIncludes() {
        return this.createElem("symbol", INCLUDES);
    }

    public NestedAttributeElement createFrame() {
        return this.createElem(new String[]{"label", "classname"}, FRAME);
    }

    @Override
    public Object createDynamicElement(String name) {
        if (KEEP_AS3_METADATA.matches(name)) {
            return this.createElem("name", KEEP_AS3_METADATA);
        }
        if (DEFINE.matches(name)) {
            return this.createElem(new String[]{"name", "value"}, DEFINE);
        }
        if (RUNTIME_SHARED_LIBRARIES.matches(name)) {
            return this.createElem("url", RUNTIME_SHARED_LIBRARIES);
        }
        if (RUNTIME_SHARED_LIBRARY_PATH.matches(name)) {
            RuntimeSharedLibraryPath runtimeSharedLibraryPath = new RuntimeSharedLibraryPath();
            this.nestedAttribs.add(runtimeSharedLibraryPath);
            return runtimeSharedLibraryPath;
        }
        if (LOAD_CONFIG.matches(name)) {
            return this.createElemAllowAppend(new String[]{"filename"}, LOAD_CONFIG);
        }
        if (SOURCE_PATH.matches(name)) {
            return this.createElem("path-element", SOURCE_PATH);
        }
        if (DefaultScriptLimits.DEFAULT_SCRIPT_LIMITS.matches(name)) {
            if (this.defaultScriptLimits == null) {
                this.defaultScriptLimits = new DefaultScriptLimits();
                return this.defaultScriptLimits;
            }
            throw new BuildException("Only one nested <default-script-limits> element is allowed in an mxmlc task.");
        }
        if (DefaultSize.DEFAULT_SIZE.matches(name)) {
            if (this.defaultSize == null) {
                this.defaultSize = new DefaultSize();
                return this.defaultSize;
            }
            throw new BuildException("Only one nested <default-size> element is allowed in an mxmlc task.");
        }
        if (EXTERNAL_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(EXTERNAL_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (INCLUDE_LIBRARIES.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(INCLUDE_LIBRARIES, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (THEME.matches(name)) {
            FlexFileSet fs = new FlexFileSet(THEME);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (INCLUDE_RESOURCE_BUNDLES.matches(name)) {
            return this.createElem("bundle", INCLUDE_RESOURCE_BUNDLES);
        }
        if (FORCE_RSLS.matches(name)) {
            FlexFileSet fs = new FlexFileSet(FORCE_RSLS);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (APPLICATION_DOMAIN.matches(name)) {
            return this.createElem(new String[]{"path-element", "application-domain-target"}, APPLICATION_DOMAIN);
        }
        return super.createDynamicElement(name);
    }

    @Override
    protected void prepareCommandline() throws BuildException {
        for (int i = 0; i < this.configVariables.length; ++i) {
            this.configVariables[i].addToCommandline(this.cmdline);
        }
        if (this.metadata != null) {
            this.metadata.addToCommandline(this.cmdline);
        }
        if (this.fonts != null) {
            this.fonts.addToCommandline(this.cmdline);
        }
        if (this.defaultScriptLimits != null) {
            this.defaultScriptLimits.addToCommandline(this.cmdline);
        }
        if (this.defaultSize != null) {
            this.defaultSize.addToCommandline(this.cmdline);
        }
        Iterator<Object> it = this.nestedAttribs.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(this.cmdline);
        }
        it = this.nestedFileSets.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(this.cmdline);
        }
        if (this.output != null) {
            new ConfigString(new OptionSpec("output", "o"), this.output).addToCommandline(this.cmdline);
        }
        this.cmdline.createArgument().setValue("--");
        if (this.file != null) {
            this.cmdline.createArgument().setValue(this.file);
        }
    }
}

