
#ifndef GL_ES
#   define aPosition	gl_Vertex.xy
#   define aTexcoords0	gl_MultiTexCoord0.xy
#   define uModelViewProjection gl_ModelViewProjectionMatrix
#	define uTextureMatrix		gl_TextureMatrix[0]

#	define lowp
#	define mediump
#	define highp
#else
	attribute vec2 aPosition;
	attribute mediump vec2 aTexcoords0;

	uniform mat4 uModelViewProjection;
	uniform mat4 uTextureMatrix;
#endif

varying lowp    vec4 oColor;
varying mediump vec2 oTexcoords;

uniform lowp vec4 color;

void main()
{
	oTexcoords = uTextureMatrix * vec4(aTexcoords0, 0.0, 1.0);
	oColor = color;
    gl_Position =  uModelViewProjection * vec4(aPosition, 0.0, 1.0);
}