#ifndef GL_ES
#   define aPosition	gl_Vertex.xy
#	define aColor		gl_Color
#   define uModelViewProjection gl_ModelViewProjectionMatrix
#	define uTextureMatrix		gl_TextureMatrix[0]

#	define lowp
#	define mediump
#	define highp
#else
	attribute vec2 aPosition;
	attribute lowp vec4 aColor;

	uniform mat4 uModelViewProjection;
	uniform mat4 uTextureMatrix;
#endif

varying lowp    vec4 oColor;

uniform mat4 uModelViewProjection;

void main()
{
	oColor = aColor;
    gl_Position =  uModelViewProjection * vec4(aPosition, 0.0, 1.0);
}
